; Starpath by HellMood/DSR
; 55/64 byte intro for MSDOS
; 1st place at "Lovebyte 2025"
;
; heaven is one step around the corner
; ... you just have to keep moving
;
; greetings to all sizecoders !

;          STAR SMOL

; this is the SMOL ** 55 bytes ** version
; it lacks sound or ESC support
; is not synced against a timer
; might be slow on real hardware
; star pattern is just okay
; and has no dithering to smoothen
; but is only ** 55 ** bytes, so you
; can customize your own starpath =)

mov al,0x13			; mode 13h, 320x200 pixels, 256 colors
B: cwd				; erase DX for pixel setting (AH = 0x0C/0x00)
int 0x10			; set graphic mode (AH = 0x00), set pixel (AH = 0x0C)
X: mov bl,0xD		; start ray depth at 14
L: mov ax,0xCCCC	; "Rrrola constant" to convert screen pointer to coordinates
mul cx				; Getting X,Y in DL,DH
mov al,dh			; getting Y into AL
mul bl				; multiply Y by current depth (into AH)
xchg ax,dx			; store Y' into DH, get X into AL
sub al,bl			; curve X by the current depth
jc W				; if left of the curve, jump to "sky"
mul bl				; multiply X by current depth (into AH)
mov al,dh			; get Y' in AL (now AL,AH = Y',X')
or al,ah			; OR for geometry and texture pattern
lea dx,[bx+si]		; get (current depth) + (current frame count) in DX (DL)
and al,dl			; mask geometry/texture by time shifted depth...
inc bx				; (increment depth by one)
test al,16			; ... to create "gaps"
jz L				; if ray did not hit, repeat pixel loop
jmp short Q			; jump over the sky ^^
W: mov al,27		; is both the star color and palette offset into sky
add dl,cl			; pseudorandom multiplication leftover DL added
jz Q				; to shifted depth, 1 in 256 chance to be a star *
A: shld ax,cx,4		; if not, shift the starcolor and add scaled pixel count
Q: mov ah,0x0C		; AH = 0xC sets a pixel when int 10h is called
loop B				; repeat for 64k pixels
inc si				; increment frame counter
jmp short B			; rinse and repeat